<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package VG Calaco
 */

// Get Theme Options Values
$vg_calaco_options = get_option("vg_calaco_options");
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo('charset'); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="vg-main-content-wrapper" class="main-container page-404">
	<div id="logo-wrapper" class="logo-center">
		<div class="logo-inside">
			<?php vg_calaco_display_bottom_logo(); // Call display top logo function; ?>
		</div>
	</div><!-- End site-logo -->
						